<?php

namespace App\Model;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ActAssignedData extends Model 
{

    protected $table = 'act_assigned_data';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('streamable_type', 'assignable_type', 'vod_url', 'aws_medialive_channel_id');

    public function incidents()
    {
        return $this->hasMany('Incident');
    }

}